// ======== ======== ======== ======== ======== ======== ======== ========
//
//	title : VSsheep[ effect.cpp ]		Auter : KENSUKE WATANABE
//											Data  : 2016/08/30
//
// -------- -------- -------- -------- -------- -------- -------- --------
//Update : 2016/08/30
//
// ======== ======== ======== ======== ======== ======== ======== ========
//-----------------------------------------------------------------------------
// CN[h
//-----------------------------------------------------------------------------
#include <math.h>
#include "main.h"
#include "manager.h"
#include "effect3DPoly.h"
#include "modeGame.h"
#include "renderer.h"
#include "texManager.h"
#include "camera.h"

int CEffect3DPoly::m_maxEffect = 0;
int CEffect3DPoly::m_cnt = 0; 
LPDIRECT3DVERTEXBUFFER9 CEffect3DPoly::m_pVtxBuffer = nullptr;
std::vector<CEffect3DPoly> CEffect3DPoly::m_vecEffect3DPoly;

//-----------------------------------------------------------------------------
// ֐
//-----------------------------------------------------------------------------
void CEffect3DPoly::Init(void)
{
	m_bUse = false;
	m_fRadius = 0.f;							// a
	m_fRadiusValue = 0.f;						// aω
	m_fColorAlphaValue = 0.f;					// l̕ω
	m_nLife = 0;								// 
	m_pos = D3DXVECTOR3(0.f, 0.f, 0.f);		// W
	m_move = D3DXVECTOR3(0.f, 0.f, 0.f);		// ړ
	m_scl = D3DXVECTOR3(0.f, 0.f, 0.f);		// g嗦
	m_rot = D3DXVECTOR3(0.f, 0.f, 0.f);		// ]p
	m_size = D3DXVECTOR3(0.f, 0.f, 0.f);		// TCY
	m_r = 0;
	m_g = 0;
	m_b = 0;
	m_a = 255;
	m_scl = D3DXVECTOR3(1.f, 1.f, 1.f);
}

//-----------------------------------------------------------------------------
// I
//-----------------------------------------------------------------------------
void CEffect3DPoly::Uninit(void)
{
	ReleaseAll();
}

//-----------------------------------------------------------------------------
// XV֐
//-----------------------------------------------------------------------------
void CEffect3DPoly::UpdateAll(void)
{	
	//obt@bN
	VERTEX_3D* pVtx;
	m_pVtxBuffer->Lock(0, 0, (void**)&pVtx, 0);

	for (int i = 0; i < m_maxEffect; i++)
	{
		auto it = &m_vecEffect3DPoly.at(i);
		if (it->m_bUse)
		{
			//gp̃GtFNg̍XV
			it->m_nLife--;	//炷
			if (it->m_nLife <= 0)
			{//0ȉɂȂ
				it->m_bUse = false;	//gptOIt
			}
			else
			{
				//F̐ݒ
				it->m_a -= static_cast<int>(it->m_fColorAlphaValue);
				if (it->m_a < 0.f)
				{//l0.0菬ȂȂ悤
					it->m_a = 0;
				}
			}
			//a̍XVƐݒ
			it->m_fRadius -= it->m_fRadiusValue;
			if (it->m_fRadius < 0.f)
			{//a0.0菬ȂȂ悤
				it->m_fRadius = 0.f;
			}

			it->m_pos += it->m_move;

			//_|S̃|SWWƔaZoď
			it->SetEffectVertex(pVtx, i);
		}
	}

	//_obt@AbN
	m_pVtxBuffer->Unlock();
}

//-----------------------------------------------------------------------------
// `揈֐
//-----------------------------------------------------------------------------
void CEffect3DPoly::DrawAll(void)
{
	// foCX̎擾
	LPDIRECT3DDEVICE9 pDevice = CRenderer::GetDevice();

	pDevice->SetRenderState(D3DRS_LIGHTING, FALSE);				// Cg\It
	pDevice->SetRenderState(D3DRS_DESTBLEND, D3DBLEND_ONE);		// DESTRGB̌WPɂ
	pDevice->SetRenderState(D3DRS_ZENABLE, D3DZB_FALSE);		// Zobt@

	D3DXMATRIX mtxScl;			// gs
	D3DXMATRIX mtxRot;			// ]s
	D3DXMATRIX mtxViewInverse;
	D3DXMATRIX mtxPos;			// ss

	// [h}gNX̍쐬
	D3DXMatrixIdentity(&mtxScl);			// 
	D3DXMatrixIdentity(&mtxRot);			// 
	D3DXMatrixIdentity(&mtxPos);			//

	D3DXMATRIX mtxView = CManager::GetCamera()->GetView();		// r[s̎擾
	mtxView._41 = 0.f;						// 
	mtxView._42 = 0.f;						// 
	mtxView._43 = 0.f;						// ss̃Jbg

	D3DXMatrixInverse(&mtxViewInverse, nullptr, &mtxView);	// ts̏o

	for (int i = 0; i < m_maxEffect; i++)
	{
		auto it = &m_vecEffect3DPoly.at(i);
		//gĂp[eBN̕`
		if (it->m_bUse)
		{
			D3DXMatrixIdentity(&it->m_mtxWorld);		// sPʍsɂ( g嗦1,0ŏ )

			// [hϊsݒ肵ĕϊ
			D3DXVECTOR3 scl = it->m_scl;
			D3DXVECTOR3 rot = it->m_rot;
			D3DXVECTOR3 pos = it->m_pos;
			D3DXMatrixScaling(&mtxScl, scl.x, scl.y, scl.z);					// gs
			D3DXMatrixRotationYawPitchRoll(&mtxRot, rot.y, rot.x, rot.z);		// ]s
			D3DXMatrixTranslation(&mtxPos, pos.x, pos.y, pos.z);				// ss

			D3DXMatrixMultiply(&it->m_mtxWorld, &it->m_mtxWorld, &mtxViewInverse);
			D3DXMatrixMultiply(&it->m_mtxWorld, &it->m_mtxWorld, &mtxScl);
			D3DXMatrixMultiply(&it->m_mtxWorld, &it->m_mtxWorld, &mtxRot);
			D3DXMatrixMultiply(&it->m_mtxWorld, &it->m_mtxWorld, &mtxPos);

			// foCXɃ[hϊsݒ
			pDevice->SetTransform(D3DTS_WORLD, &it->m_mtxWorld);

			// _tH[}bg̐ݒ
			pDevice->SetFVF(FVF_VERTEX_3D);

			// Xg[̐ݒ
			pDevice->SetStreamSource(0, m_pVtxBuffer, 0, sizeof(VERTEX_3D));

			// eNX`̐ݒ
			pDevice->SetTexture(0, CManager::GetTexManager()->GetTexInterface(it->m_strFilePass));

			pDevice->DrawPrimitive(D3DPT_TRIANGLESTRIP, i * 4, 2);	//v~eBu
		}
	}

	pDevice->SetRenderState(D3DRS_ZENABLE, D3DZB_TRUE);			// Zobt@
	// Cg̕\Lɂ
	pDevice->SetRenderState(D3DRS_LIGHTING, TRUE);

	//_[Xe[g̐ݒ߂
	pDevice->SetRenderState(D3DRS_BLENDOP, D3DBLENDOP_ADD);
	pDevice->SetRenderState(D3DRS_SRCBLEND, D3DBLEND_SRCALPHA);
	pDevice->SetRenderState(D3DRS_DESTBLEND, D3DBLEND_INVSRCALPHA);
}

//-----------------------------------------------------------------------------
// 쐬
//-----------------------------------------------------------------------------
void CEffect3DPoly::Create(int n, std::string texName)
{
	// eNX`̃Zbg
	CManager::GetTexManager()->SetTex(texName);

	// GtFNg
	CEffect3DPoly effPoly;
	effPoly.Init();
	effPoly.m_strFilePass = texName;

	// LpVeBw
	m_maxEffect = n;
	m_vecEffect3DPoly.reserve(m_maxEffect);

	for (int nCnt = 0; nCnt < m_maxEffect; nCnt++)
	{
		m_vecEffect3DPoly.push_back(effPoly);
	}
	CEffect3DPoly::MakeVertexEffect();
}

//-----------------------------------------------------------------------------
// _쐬֐
//-----------------------------------------------------------------------------
HRESULT CEffect3DPoly::MakeVertexEffect()
{
	LPDIRECT3DDEVICE9 pDevice = CRenderer::GetDevice();

	//_obt@쐬
	if (FAILED(pDevice->CreateVertexBuffer(
		sizeof(VERTEX_3D) * NUM_VERTEX * m_maxEffect,
		D3DUSAGE_WRITEONLY, FVF_VERTEX_3D, D3DPOOL_MANAGED, &m_pVtxBuffer, nullptr)))
	{
		return E_FAIL;
	}

	//obt@bN
	VERTEX_3D* pVtx;
	m_pVtxBuffer->Lock(0, 0, (void**)&pVtx, 0);

	for (int i = 0; i < m_maxEffect; i++)
	{
		auto it = &m_vecEffect3DPoly.at(i);
		//WƐFݒ
		pVtx[0 + i * 4].tex = D3DXVECTOR2(0.f, 0.f);
		pVtx[1 + i * 4].tex = D3DXVECTOR2(1.f, 0.f);
		pVtx[2 + i * 4].tex = D3DXVECTOR2(0.f, 1.f);
		pVtx[3 + i * 4].tex = D3DXVECTOR2(1.f, 1.f);
		pVtx[0 + i * 4].pos = D3DXVECTOR3(0.f, 0.f, 0.f);
		pVtx[1 + i * 4].pos = D3DXVECTOR3(0.f, 0.f, 0.f);
		pVtx[2 + i * 4].pos = D3DXVECTOR3(0.f, 0.f, 0.f);
		pVtx[3 + i * 4].pos = D3DXVECTOR3(0.f, 0.f, 0.f);
		pVtx[0 + i * 4].col = D3DCOLOR_RGBA(it->m_r, it->m_g, it->m_b, it->m_a);
		pVtx[1 + i * 4].col = D3DCOLOR_RGBA(it->m_r, it->m_g, it->m_b, it->m_a);
		pVtx[2 + i * 4].col = D3DCOLOR_RGBA(it->m_r, it->m_g, it->m_b, it->m_a);
		pVtx[3 + i * 4].col = D3DCOLOR_RGBA(it->m_r, it->m_g, it->m_b, it->m_a);
		pVtx[0 + i * 4].nom = D3DXVECTOR3(0.f, 1.f, 0.f);
		pVtx[1 + i * 4].nom = D3DXVECTOR3(0.f, 1.f, 0.f);
		pVtx[2 + i * 4].nom = D3DXVECTOR3(0.f, 1.f, 0.f);
		pVtx[3 + i * 4].nom = D3DXVECTOR3(0.f, 1.f, 0.f);
	}
	//bN̉
	m_pVtxBuffer->Unlock();

	return NOERROR;
}

//-----------------------------------------------------------------------------
// GtFNgݒ
//-----------------------------------------------------------------------------
void CEffect3DPoly::SetEffect3DPoly(D3DXVECTOR3 pos, D3DXVECTOR3 rot, D3DXVECTOR3 move, float radius, int r, int g, int b, int a, int life, std::string texName)
{
	// eNX`̃Zbg
	CManager::GetTexManager()->SetTex(texName);

	for (int i = 0; i < m_maxEffect; i++)
	{
		auto it = &m_vecEffect3DPoly.at(i);
		if(it->m_bUse == false)
		{
			// GtFNgZbg
			it->m_strFilePass = texName;
			it->m_pos = pos;
			it->m_move = move;
			it->m_rot = rot;
			it->m_fRadius = radius;
			it->m_r = r; 
			it->m_g = g; 
			it->m_b = b; 
			it->m_a = a;
			it->m_nLife = life;

			it->m_bUse = true;
			it->m_fRadiusValue = radius * 0.5f / life;		//s܂łɑ傫𔼕ɂȂ悤ɒlݒ
			it->m_fColorAlphaValue = 1.f / life;			//s܂łɓɂȂ悤ɒlݒ
			break;
		}
	}
}

//-----------------------------------------------------------------------------
// _Wݒ
//-----------------------------------------------------------------------------
void CEffect3DPoly::SetEffectVertex(VERTEX_3D* pVtx, int n)
{
	//_W̐ݒ
	pVtx[0 + n * 4].pos = D3DXVECTOR3(-m_fRadius, m_fRadius, 0.f);
	pVtx[1 + n * 4].pos = D3DXVECTOR3(m_fRadius, m_fRadius, 0.f);
	pVtx[2 + n * 4].pos = D3DXVECTOR3(-m_fRadius, -m_fRadius, 0.f);
	pVtx[3 + n * 4].pos = D3DXVECTOR3(m_fRadius, -m_fRadius, 0.f);

	//_F̐ݒ
	pVtx[0 + n * 4].col = D3DCOLOR_RGBA(m_r, m_g, m_b, m_a);
	pVtx[1 + n * 4].col = D3DCOLOR_RGBA(m_r, m_g, m_b, m_a);
	pVtx[2 + n * 4].col = D3DCOLOR_RGBA(m_r, m_g, m_b, m_a);
	pVtx[3 + n * 4].col = D3DCOLOR_RGBA(m_r, m_g, m_b, m_a);
}

//-----------------------------------------------------------------------------
// StbV
//-----------------------------------------------------------------------------
void CEffect3DPoly::FlashAll(void)
{
	//obt@bN
	VERTEX_3D* pVtx;
	m_pVtxBuffer->Lock(0, 0, (void**)&pVtx, 0);
	for (int i = 0; i < m_maxEffect; i++)
	{
		auto it = &m_vecEffect3DPoly.at(i);
		if (it->m_bUse == false)return;
		//_F̐ݒ
		pVtx[0 + i * 4].col = D3DCOLOR_RGBA(0, 0, 0, 0);
		pVtx[1 + i * 4].col = D3DCOLOR_RGBA(0, 0, 0, 0);
		pVtx[2 + i * 4].col = D3DCOLOR_RGBA(0, 0, 0, 0);
		pVtx[3 + i * 4].col = D3DCOLOR_RGBA(0, 0, 0, 0);
		it->m_bUse = false;
	}
	m_pVtxBuffer->Unlock();
}

//-----------------------------------------------------------------------------
// SJ
//-----------------------------------------------------------------------------
void CEffect3DPoly::ReleaseAll(void)
{
	m_vecEffect3DPoly.erase(remove_if(m_vecEffect3DPoly.begin(), m_vecEffect3DPoly.end(), [](CEffect3DPoly &it){
		UNREFERENCED_PARAMETER(it); return true; }), m_vecEffect3DPoly.end());

	// Vtxobt@̉
	if (m_pVtxBuffer != nullptr)
	{
		m_pVtxBuffer->Release();
		m_pVtxBuffer = nullptr;
	}

	m_maxEffect = 0;
}